package gov.va.genisis2.bs.converter;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.bs.data.model.Bookmark;
import gov.va.genisis2.bs.data.model.Label;
import gov.va.genisis2.ts.common.dto.BookmarkDTO;

/**
 * Used to convert Bookmark Object to Bookmark DTO's and vice versa
 * @author PII
 */
@Component
public class BookmarkConverter implements Converter<Bookmark, BookmarkDTO> {
	
	@Autowired
	public LabelConverter labelConverter;
	
	@Resource(name = "ontologyNamesMap")
	private Map<String, String> ontologyNamesMap;
	
	@Override
	public BookmarkDTO convert(Bookmark bookmark) {
		BookmarkDTO bookmarkDto = new BookmarkDTO();
		
		bookmarkDto.setBookmarkId(bookmark.getBookmarkId());
		bookmarkDto.setConceptUri(bookmark.getConceptUri());
		bookmarkDto.setConceptName(bookmark.getConceptName());
		bookmarkDto.setConceptNameWithOntologyName(bookmark.getConceptName()  + getOntologyNameForConceptUri(bookmark.getConceptUri()));
		bookmarkDto.setUsername(bookmark.getUsername());

		List<Label> labels = bookmark.getLabels();

		if (null != labels && !labels.isEmpty()) {
			bookmarkDto.setLabels(labelConverter.convert(labels));
		}

		return bookmarkDto;
	}
	
	public Bookmark convert(BookmarkDTO bookmarkDto) {
		Bookmark bookmark = new Bookmark();
		
		bookmark.setBookmarkId(bookmarkDto.getBookmarkId());
		bookmark.setConceptUri(bookmarkDto.getConceptUri());
		bookmark.setConceptName(bookmarkDto.getConceptName());
		bookmark.setUsername(bookmarkDto.getUsername());
		
		return bookmark;
	}
	
	private String getOntologyNameForConceptUri(String conceptUri) {
		if (null == conceptUri) {
			return null;
		}
	
		String ontologyName = ontologyNamesMap.entrySet().stream().filter(e -> conceptUri.toUpperCase().startsWith(e.getKey()))
				.map(Map.Entry::getValue).findFirst().orElse(null);

		return (null != ontologyName) ? " [" + ontologyName + "]" : null;
	}

}
